/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.datatype;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class Color
implements SWFEncodeable {
    public static final int RGB = 3;
    public static final int RGBA = 4;
    private static final String FORMAT = "Color: { red=%d; green=%d; blue=%d; alpha=%d}";
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 255;
    private final transient int red;
    private final transient int green;
    private final transient int blue;
    private final transient int alpha;

    public Color(SWFDecoder coder, Context context) throws IOException {
        this.red = coder.readByte();
        this.green = coder.readByte();
        this.blue = coder.readByte();
        this.alpha = context.contains(3) ? coder.readByte() : 255;
    }

    public Color(int rVal, int gVal, int bVal) {
        this(rVal, gVal, bVal, 255);
    }

    public Color(int rVal, int gVal, int bVal, int aVal) {
        if (rVal < 0 || rVal > 255) {
            throw new IllegalArgumentRangeException(0, 255, rVal);
        }
        if (gVal < 0 || gVal > 255) {
            throw new IllegalArgumentRangeException(0, 255, gVal);
        }
        if (bVal < 0 || bVal > 255) {
            throw new IllegalArgumentRangeException(0, 255, bVal);
        }
        if (aVal < 0 || aVal > 255) {
            throw new IllegalArgumentRangeException(0, 255, aVal);
        }
        this.red = rVal;
        this.green = gVal;
        this.blue = bVal;
        this.alpha = aVal;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String toString() {
        return String.format(FORMAT, this.red, this.green, this.blue, this.alpha);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof Color) {
            Color color = (Color)object;
            result = this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == color.alpha;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((this.red * 31 + this.green) * 31 + this.blue) * 31 + this.alpha;
    }

    @Override
    public int prepareToEncode(Context context) {
        int size = context.contains(3) ? 4 : 3;
        return size;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.red);
        coder.writeByte(this.green);
        coder.writeByte(this.blue);
        if (context.contains(3)) {
            coder.writeByte(this.alpha);
        }
    }
}

