/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.button;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.ColorTransform;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class ButtonColorTransform
implements MovieTag {
    private static final String FORMAT = "ButtonColorTransform: { identifier=%d; colorTransform=%s}";
    private int identifier;
    private ColorTransform colorTransform;
    private transient int length;

    public ButtonColorTransform(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.colorTransform = new ColorTransform(coder, context);
        coder.check(this.length);
        coder.unmark();
    }

    public ButtonColorTransform(int uid, ColorTransform cxform) {
        this.setIdentifier(uid);
        this.setColorTransform(cxform);
    }

    public ButtonColorTransform(ButtonColorTransform object) {
        this.identifier = object.identifier;
        this.colorTransform = object.colorTransform;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public ColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public void setColorTransform(ColorTransform cxform) {
        if (cxform == null) {
            throw new IllegalArgumentException();
        }
        this.colorTransform = cxform;
    }

    @Override
    public ButtonColorTransform copy() {
        return new ButtonColorTransform(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.colorTransform);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4 + this.colorTransform.prepareToEncode(context);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1535);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x5C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        this.colorTransform.encode(coder, context);
        coder.check(this.length);
        coder.unmark();
    }
}

