/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class Protect
implements MovieTag {
    private static final String FORMAT = "Protect: { password=%s}";
    private String password;
    private transient int length;

    public Protect(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        if (this.length > 0) {
            coder.readUnsignedShort();
            this.password = coder.readString(this.length - 2);
            while (this.password.charAt(this.password.length() - 1) == '\u0000') {
                this.password = this.password.substring(0, this.password.length() - 1);
            }
        }
        coder.check(this.length);
        coder.unmark();
    }

    public Protect() {
    }

    public Protect(String pass) {
        this.setPassword(pass);
    }

    public Protect(Protect object) {
        this.password = object.password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aString) {
        if (aString == null) {
            throw new IllegalArgumentException();
        }
        this.password = aString;
    }

    @Override
    public Protect copy() {
        return new Protect(this);
    }

    public String toString() {
        return String.format(FORMAT, this.password);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 0;
        if (this.password != null) {
            this.length += 2 + context.strlen(this.password);
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1599);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x600 | this.length);
        }
        if (this.password != null) {
            coder.writeShort(0);
            coder.writeString(this.password);
        }
    }
}

